<?php

return [
    'copy_link' => 'Copy',
    'public_banner' => 'Public, read-only documentation link generated from Super Admin settings.',
    'api_docs' => 'Rest API',
    'api_docs_help' => 'Centralized documentation for POS, delivery, waiter, and kiosk integrations.',
    'toc' => 'On this page',
    'theme' => 'Theme',
    'overview_title' => 'Overview',
    'overview_desc' => 'Lightweight, token-based endpoints for building mobile POS, delivery, and admin experiences without touching core POS logic.',
    'base_url' => 'Base URL',
    'auth' => 'Auth',
    'formats' => 'Formats',

    'auth_title' => 'Authentication & Tokens',
    'auth_desc' => 'Issue scoped bearer tokens per staff account. Tokens inherit restaurant and branch context.',
    'login_summary' => 'Exchange staff credentials for a bearer token.',
    'login_note_token' => 'Send the returned token as Authorization: Bearer <token> on every request.',
    'login_note_permissions' => 'Token privileges match the user roles and permissions.',
    'me_summary' => 'Return the authenticated profile and enabled modules.',
    'me_note_roles' => 'Use the roles array to drive client-side feature flags.',

    'platform_title' => 'Platform & Config',
    'platform_desc' => 'Locale, currency, features, branches, and payment gateway flags to bootstrap clients.',
    'platform_config' => 'Bootstrap restaurant, branch, modules, and feature flags for the current token.',
    'platform_note_cache' => 'Responses are branch-aware. Switch branches to refresh context.',
    'languages_summary' => 'List active languages with codes and status.',
    'languages_note' => 'Fallback uses LanguageSetting::LANGUAGES if DB columns are limited.',
    'permissions_summary' => 'Return role names and granular permissions for the token.',
    'printers_summary' => 'List branch printers for routing tickets.',
    'receipt_summary' => 'Fetch receipt header/footer and formatting.',
    'switch_branch' => 'Switch the active branch for the current token.',

    'pos_title' => 'POS Endpoints',
    'pos_desc' => 'Menu, items, orders, and reservations for FOH and KDS workflows.',
    'menus_summary' => 'List active menus for the current branch.',
    'items_summary' => 'List menu items with pricing. Use filters for menus/categories.',
    'items_note_filters' => 'Filter by menu or category ids to reduce payload size.',
    'categories_summary' => 'List menu categories for the branch.',
    'items_by_category' => 'Fetch items by category.',
    'items_by_menu' => 'Fetch items for a specific menu.',
    'variations' => 'List variations for an item.',
    'modifiers' => 'List modifier groups for an item.',
    'extra_charges' => 'Fetch extra charges by order type.',
    'orders_create' => 'Create a POS order with items, actions, and routing.',
    'orders_list' => 'List orders with pagination.',
    'orders_filters' => 'Filter by status, type, branch_id, and page.',
    'orders_resilient' => 'Endpoint now returns base pagination even if enrichment (items/charges/taxes) fails; server logs capture any hydration errors.',
    'orders_detail' => 'Fetch a single order with totals, discount, delivery fee, charges, taxes, and per-item price/amount/tax.',
    'orders_status' => 'Update an order status (allowed: placed, confirmed, preparing, food_ready, ready_for_pickup, out_for_delivery, served, delivered, cancelled).',
    'orders_pay' => 'Pay an order with payment records.',
    'orders_detail_dinein' => 'Dine-in detail shows table assignment, waiter, customer attach/create, items, charges, taxes, and cart summary.',
    'orders_invoice' => 'Use a normal invoice layout: each item with name, qty, unit price, line total; bottom summary with sub_total, discount_amount, tax_total, charges_total, delivery_fee, grand_total; show pay/print buttons as needed.',
    'orders_status_flow' => 'Move orders through placed â†’ confirmed/preparing â†’ served/delivered; cancel before preparation; hard delete should be guarded to pre-served/pre-paid states only.',
    'orders_pay_note' => 'Marking paid also releases the table (sets available_status=available and clears table_sessions) and updates amount_paid.',
    'orders_discount_note' => 'Discounts live on the order (discount_type/discount_value/discount_amount); add/remove via an order update flow.',
    'orders_table_waiter' => 'Waiter/table reassignment requires an order update endpoint; otherwise set on creation.',
    'orders_customer_note' => 'Attach an existing customer_id or create via POST /pos/customers when not found.',
    'orders_print_note' => 'Printing is handled by POS/printer flow; no dedicated print endpoint in this module.',
    'customers' => 'List POS customers.',
    'customers_create' => 'Create a POS customer.',
    'phone_codes' => 'List phone codes for customer creation.',
    'taxes' => 'List taxes for the branch.',
    'restaurants' => 'List restaurants (super admin tokens); falls back to current restaurant on single-tenant setups.',
    'branches' => 'List branches for current restaurant.',
    'reservations' => 'List reservations.',
    'reservations_create' => 'Create a reservation.',
    'reservations_status' => 'Update reservation status.',
    'reservations_today' => 'Today\'s reservations shortcut.',
    'tables' => 'List tables for the branch.',
    'tables_unlock' => 'Force unlock a table.',
    'order_types' => 'List available order types.',
    'actions' => 'List allowed order actions.',
    'delivery_platforms' => 'List configured delivery platforms.',
    'order_number' => 'Fetch the next order number.',
    'waiters' => 'List waiters/delivery staff (filter by ?role=delivery, ?search=<name/phone>, includes phone/status/roles and delivery_executives table).',
    'delivery_executives' => 'List delivery executives with status/phone filters (statuses: available, in_delivery, inactive).',

    'customer_title' => 'Customer App',
    'customer_desc' => 'Customer catalog and order submission endpoints.',
    'catalog_summary' => 'Return menus, categories, and items for customer apps.',
    'customer_order' => 'Place a customer order (delivery/takeaway).',
    'customer_order_note' => 'Include customer_address_id for delivery flows.',
    'customer_orders' => 'List customer orders for the current token.',

    'notifications_title' => 'Notifications',
    'notifications_desc' => 'Register device tokens and fetch in-app notifications.',
    'notifications_register' => 'Register a device token for push notifications.',
    'notifications_list' => 'List notifications for the current user.',
    'notifications_read' => 'Mark a notification as read.',
    'notifications_test' => 'Send a test notification.',

    'sdks_title' => 'SDK Examples',
    'sdks_desc' => 'Use any language shown to consume endpoints with bearer auth.',
    'auth_required' => 'Auth required',
    'header' => 'Header',
    'value' => 'Value',
    'body_schema' => 'Request body',

    'shared_title' => 'Shared & Utilities',
    'shared_desc' => 'Common lookups and helpers for building clients.',
    'currencies_summary' => 'List currencies with codes and rates.',
    'api_docs_help' => 'Centralized documentation for POS, delivery, waiter, and kiosk integrations.',
    'toc' => 'On this page',
    'theme' => 'Theme',
    'overview_title' => 'Overview',
    'overview_desc' => 'Lightweight, token-based endpoints for building mobile POS, delivery, and admin experiences without touching core POS logic.',
    'base_url' => 'Base URL',
    'auth' => 'Auth',
    'formats' => 'Formats',

    'auth_title' => 'Authentication & Tokens',
    'auth_desc' => 'Issue scoped bearer tokens per staff account. Tokens inherit restaurant and branch context.',
    'login_summary' => 'Exchange staff credentials for a bearer token.',
    'login_note_token' => 'Send the returned token as Authorization: Bearer <token> on every request.',
    'login_note_permissions' => 'Token privileges match the user roles and permissions.',
    'me_summary' => 'Return the authenticated profile and enabled modules.',
    'me_note_roles' => 'Use the roles array to drive client-side feature flags.',

    'platform_title' => 'Platform & Config',
    'platform_desc' => 'Locale, currency, features, branches, and payment gateway flags to bootstrap clients.',
    'platform_config' => 'Bootstrap restaurant, branch, modules, and feature flags for the current token.',
    'platform_note_cache' => 'Responses are branch-aware. Switch branches to refresh context.',
    'languages_summary' => 'List active languages with codes and status.',
    'languages_note' => 'Fallback uses LanguageSetting::LANGUAGES if DB columns are limited.',
    'permissions_summary' => 'Return role names and granular permissions for the token.',
    'printers_summary' => 'List branch printers for routing tickets.',
    'receipt_summary' => 'Fetch receipt header/footer and formatting.',
    'switch_branch' => 'Switch the active branch for the current token.',

    'pos_title' => 'POS Endpoints',
    'pos_desc' => 'Menu, items, orders, and reservations for FOH and KDS workflows.',
    'menus_summary' => 'List active menus for the current branch.',
    'items_summary' => 'List menu items with pricing. Use filters for menus/categories.',
    'items_note_filters' => 'Filter by menu or category ids to reduce payload size.',
    'categories_summary' => 'List menu categories for the branch.',
    'items_by_category' => 'Fetch items by category.',
    'items_by_menu' => 'Fetch items for a specific menu.',
    'variations' => 'List variations for an item.',
    'modifiers' => 'List modifier groups for an item.',
    'extra_charges' => 'Fetch extra charges by order type.',
    'orders_create' => 'Create a POS order with items, actions, and routing.',
    'orders_list' => 'List orders with pagination.',
    'orders_filters' => 'Filter by status, type, branch_id, and page.',
    'orders_resilient' => 'Endpoint now returns base pagination even if enrichment (items/charges/taxes) fails; server logs capture any hydration errors.',
    'orders_detail' => 'Fetch a single order with totals, discount, delivery fee, charges, taxes, and per-item price/amount/tax.',
    'orders_status' => 'Update an order status (allowed: placed, confirmed, preparing, food_ready, ready_for_pickup, out_for_delivery, served, delivered, cancelled).',
    'orders_pay' => 'Pay an order with payment records.',
    'orders_detail_dinein' => 'Dine-in detail shows table assignment, waiter, customer attach/create, items, charges, taxes, and cart summary.',
    'orders_invoice' => 'Use a normal invoice layout: each item with name, qty, unit price, line total; bottom summary with sub_total, discount_amount, tax_total, charges_total, delivery_fee, grand_total; show pay/print buttons as needed.',
    'orders_status_flow' => 'Move orders through placed â†’ confirmed/preparing â†’ served/delivered; cancel before preparation; hard delete should be guarded to pre-served/pre-paid states only.',
    'orders_pay_note' => 'Marking paid also releases the table (sets available_status=available and clears table_sessions) and updates amount_paid.',
    'orders_discount_note' => 'Discounts live on the order (discount_type/discount_value/discount_amount); add/remove via an order update flow.',
    'orders_table_waiter' => 'Waiter/table reassignment requires an order update endpoint; otherwise set on creation.',
    'orders_customer_note' => 'Attach an existing customer_id or create via POST /pos/customers when not found.',
    'orders_print_note' => 'Printing is handled by POS/printer flow; no dedicated print endpoint in this module.',
    'customers' => 'List POS customers.',
    'customers_create' => 'Create a POS customer.',
    'phone_codes' => 'List phone codes for customer creation.',
    'taxes' => 'List taxes for the branch.',
    'restaurants' => 'List restaurants (super admin tokens); falls back to current restaurant on single-tenant setups.',
    'branches' => 'List branches for current restaurant.',
    'reservations' => 'List reservations.',
    'reservations_create' => 'Create a reservation.',
    'reservations_status' => 'Update reservation status.',
    'reservations_today' => 'Today\'s reservations shortcut.',
    'tables' => 'List tables for the branch.',
    'tables_unlock' => 'Force unlock a table.',
    'order_types' => 'List available order types.',
    'actions' => 'List allowed order actions.',
    'delivery_platforms' => 'List configured delivery platforms.',
    'order_number' => 'Fetch the next order number.',
    'waiters' => 'List waiters/delivery staff (filter by ?role=delivery, ?search=<name/phone>, includes phone/status/roles and delivery_executives table).',
    'delivery_executives' => 'List delivery executives with status/phone filters (statuses: available, in_delivery, inactive).',

    'customer_title' => 'Customer App',
    'customer_desc' => 'Customer catalog and order submission endpoints.',
    'catalog_summary' => 'Return menus, categories, and items for customer apps.',
    'customer_order' => 'Place a customer order (delivery/takeaway).',
    'customer_order_note' => 'Include customer_address_id for delivery flows.',
    'customer_orders' => 'List customer orders for the current token.',

    'notifications_title' => 'Notifications',
    'notifications_desc' => 'Register device tokens and fetch in-app notifications.',
    'notifications_register' => 'Register a device token for push notifications.',
    'notifications_list' => 'List notifications for the current user.',
    'notifications_read' => 'Mark a notification as read.',
    'notifications_test' => 'Send a test notification.',

    'sdks_title' => 'SDK Examples',
    'sdks_desc' => 'Use any language shown to consume endpoints with bearer auth.',
    'auth_required' => 'Auth required',
    'header' => 'Header',
    'value' => 'Value',
    'body_schema' => 'Request body',

    'shared_title' => 'Shared & Utilities',
    'shared_desc' => 'Common lookups and helpers for building clients.',
    'currencies_summary' => 'List currencies with codes and rates.',
    'gateways_summary' => 'Payment gateway meta for the restaurant.',
    'staff_summary' => 'List staff scoped to the restaurant.',
    'roles_summary' => 'List role names attached to the restaurant.',
    'areas_summary' => 'List delivery areas for the branch.',
    'customer_addresses' => 'List customer addresses by customer_id.',

    'multipos_title' => 'MultiPOS Devices',
    'multipos_desc' => 'Register and check POS machines for branch devices.',
    'multipos_register' => 'Register a POS device',
    'multipos_check' => 'Check POS device status',

    // New keys added 2026-01-14
    'login_note_rate_limit' => 'Rate limited: 5 requests per minute to prevent brute force attacks.',
    'price_fallback_note' => 'Item price is optional. If not provided or zero, price is fetched from MenuItem database.',
    'order_number_lock_note' => 'Uses database-level locking to prevent duplicate order numbers in concurrent requests.',
    'delivery_executives_note' => 'Filter by ?status=available|in_delivery|inactive. Returns phone and current status.',
];
